#1. Load Required Packages and data frame
required_packages <- c("readxl", "dplyr", "nortest")
for (package in required_packages) {
  if (!requireNamespace(package, quietly = TRUE)) {
    install.packages(package)
  }
  library(package, character.only = TRUE)
}

file_path <- '/COHORT_Prediction_of_CIP.xlsx'
df <- read_excel(file_path, sheet = "cohort", na = "#N/A")

#2.2 Image analysis
source("2.2_FDG-PET_CT.R", local = TRUE)
#Outoput:
#text

#3.1 Study population
source("3.1_Patient_Characteristics.R", local = TRUE)
#Statistical Analysis:
#- lillietest for distribution for numeric variables
#- M-W-U test tests for normally distributed numeric variables
#- t-test for not normally distributed numeric variables
#- Fisher's Exact test for group size < 11 for binary variables
#- Chi-squared test for group size > 10 for binary variables
#Outoput:
#- text
#- table 1
#- food notes Table 1


#3.2 Evaluation of irPneumonitis
source("3.2_Pneumonitis.R", local = TRUE)
#Statistical Analysis:
#- Quantil Test
#- Fisher's Exact test for group size < 11 for binary variables
#- Chi-squared test for group size > 10 for binary variables
#- Relative risk and Relative Risk Reduction
#Outoput:
#- text


#3.3 3.3	Comparability of radioligand uptake measured on different PET/CT devices
source("3.3_PET_CT_Devices.R", local = TRUE)
#Statistical Analysis:
#- Kruskal-Wallis-Test
#- Bonferroni correction
#Outoput:
#- food notes Table S1
#- text
#- Table S1 Comparing SUV measurements regarding PET-CT scanner


#3.4	Comparison between pretherapeutic tracer uptake and occurrence of pneumonitis
source("3.4_SUV_Correlation.R", local = TRUE)
#Statistical Analysis:
#- lillietest for distribution for numeric variables
#- M-W-U tests for normally distributed numeric variables
#- t-test for not normally distributed numeric variables
#Outoput:
#- food notes Table 2
#- table 2: SUV variables compared with the occurrence of pneumonitis during immunotherapy
#- table S2: All patients
#- table S3: Subgroup
#text

source("3.4_SUV_Overview.R", local = TRUE)
#Statistical Analysis:
#- t-test
#Boxplot
#Outoput:
#FigS1 Overview


source("3.4_SUV_Forest_Plot.R", local = TRUE)
#Statistical Analysis:
#- t-test
#logistic regression
#Forest plot
#Outoput:
#Fig1 Forest plot
#text
